#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Artober - MazifiqueMod01.fsh  by Flopine  
//https://www.shadertoy.com/view/cds3zX
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Code by Flopine

// Thanks to wsmind, leon, XT95, lsdlive, lamogui, 
// Coyhot, Alkama,YX, NuSan, slerpy, wwrighter 
// BigWings, FabriceNeyret and Blackle for teaching me

// Thanks LJ for giving me the spark :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  
// https://twitter.com/CookieDemoparty


#define PI acos(-1.)
#define rot(a) mat2(cos(a),sin(a),-sin(a),cos(a))

#define noise(u) texture2D(texture0, u, 0.).x

struct obj {
    float d;
    vec3 scol;
    vec3 lcol;
};

obj minobj (obj a, obj b)
{
    if(a.d < b.d) return a;
    else return b;
}

float truchet (vec2 uv)
{
    vec2 id = floor(uv);
    uv = fract(uv)-.5;
    if (noise(id*0.15)<.5) uv.x*= -1.;

    vec2 uu = uv;
    float s = (uv.x > -uv.y) ? 1.: -1.;
    uv.x -= .5*s;
    float d = abs(uv.x+uv.y);
    
    return d;
}

float extrude (vec3 p, float d, float h)
{
    vec2 q = vec2(d, abs(p.z)-h);
    return min(0., max(q.x, q.y))+length(max(q, 0.));
}

obj SDF (vec3 p)
{   
    p.x += iTime;
    
    p.yz*= rot(-atan(1./sqrt(2.)));   
    float t = truchet(p.xz)*.5;
    p.xz *= rot(PI/4.);
   
    obj e = obj( extrude(p.xzy, t, 0.4)-0.03, vec3(0.1, 0.5, 0.), vec3(0.99,0.9,.1) );
    
    p.y +=  t;
    obj g = obj( abs(p.y)-0.2, vec3(0.7, 0.1, 0.5), vec3(0.99, 0.9, 0.99) );
    
    return minobj(e, g);
}

vec3 gn (vec3 p)
{
    vec2 eps = vec2(0.001, 0.);
    return normalize( SDF(p).d-vec3(SDF(p-eps.xyy).d, SDF(p-eps.yxy).d, SDF(p-eps.yyx).d) );   
}

float AO (vec3 p, vec3 n, float e)
{return clamp(SDF(p+e*n).d/e, 0., 1. );}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.y;
    vec3 ro = vec3(uv*4., -30.), rd=vec3(0.,0.,1.),p=ro,
    col = vec3(0.), l = normalize(vec3(0.5, 0.1, -2.));
    
    obj O;    
    for(float i=0.; i<64.; i++)
    {
        O = SDF(p);
        if (O.d<0.001) break;
        p += O.d*rd;
    }
  
    vec3 n = gn(p);
    float li = max(dot(n,l), 0.);
    float ao = AO(p,n,0.05)+AO(p,n,0.1)+AO(p,n,0.2);
    col = mix(O.scol, O.lcol, li)*ao/2.5;
    
    // Output to screen
    fragColor = vec4(sqrt(col),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

